;
;***********************
; DEMO LED & 7 SEGMENT *
;     EXPERIMENT 1     *
;***********************
;
       CPU  "8085.TBL"
       HOF  "INT8"
;
;
       ORG  2100H

PCTRL:  EQU  0BBH
SEG:    EQU  0B9H
LED:    EQU  0BAH
DELAY:  EQU  0FH
SYSCAL: EQU  2
;
;
START: MVI  A,80H
       OUT  PCTRL
       MVI  C,16
       LXI  H,TAB_SEG
       LXI  D,TAB_LED
;
START1:
       MOV  A,M
       OUT  SEG
       LDAX D
       OUT  LED
       MVI  B,0
       MVI  A,DELAY
       RST  SYSCAL
;
       INX  H
       INX  D
       MOV  A,C
       CPI  9
       CZ   WAIT
       DCR  C
       JNZ  START1
       JMP  START
;
;/* led wait */

WAIT:  XRA  A
       OUT  LED
       MVI  B,80H
       MVI  A,DELAY
       RST  SYSCAL
       RET
;
;/* DATA TABLE */

TAB_SEG: DFB  3FH,06H,5BH,4FH     ;SEGMENT
         DFB  66H,6DH,7DH,07H
         DFB  7FH,6FH,77H,7CH
         DFB  39H,5EH,79H,71H

TAB_LED: DFB  01H,02H,04H,08H     ;LED
         DFB  10H,20H,40H,80H
         DFB  80H,40H,20H,10H
         DFB  08H,04H,02H,01H
       END
;
;
